#!/bin/bash
# set -e

ip=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($2,a," ");print a[1]}')
mask=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($4,a," ");print a[1]}')
gway=$(ip route show | grep "default" | awk -F " " '{print $3}')
device=$(connmanctl services | grep "ethernet" | awk '{split($0,a," ");print a[3]}')
dns1=$(connmanctl services $device | grep "Nameservers = " | awk -F " " '{print $4}' | tr -d ',')
dns2=$(connmanctl services $device | grep "Nameservers = " | awk -F " " '{print $5}' | tr -d ',')
dhcp=$(cat ~/lx4/last-network-config.txt | grep -i "dhcp=" | cut -c 6-10)

echo -e "dev=$device"
echo -e "ip=$ip"
echo -e "mask=$mask"
echo -e "gway=$gway"
echo -e "dns1=$dns1"
echo -e "dns2=$dns2"
echo -e "dhcp=$dhcp"
