#!/bin/bash
# set -e

ip=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($2,a," ");print a[1]}')
mask=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($4,a," ");print a[1]}')
gway=$(ip route show | grep "default" | awk -F " " '{print $3}')
#dns=$(cat /etc/resolv.conf | grep nameserver -m 2 | awk -F " " '{print $2}')

device=$(connmanctl services | grep "ethernet" | awk '{split($0,a," ");print a[3]}')
dns1=$(connmanctl services $device | grep "Nameservers = " | awk -F " " '{print $4}' | tr -d ',')
dns2=$(connmanctl services $device | grep "Nameservers = " | awk -F " " '{print $5}' | tr -d ',')
#dhcp=$(cat ~/lx4/last-network-config.txt | grep -i "dhcp=" | cut -c 6-10)

#mac=$(ifconfig | grep "HWaddr" | awk -F " " '{print $5}' | sed "s/://g")
#ethfile="/var/lib/connman/ethernet_${mac}_cable/settings"
ethfile="/var/lib/connman/${device}/settings"
ipv4Method=$(cat $ethfile | grep "IPv4.method=")
ipv4Method=${ipv4Method:12}

dhcpmode=$(connmanctl services $device | grep "IPv4 = " | awk -F " |=" '{print $8}' | tr -d ',')
# manual OR dhcp
dhcp=false

if [ $dhcpmode == "dhcp" ]; then
   dhcp=true
fi

#if [ $ipv4Method == "dhcp" ]; then
#   dhcp=true
#fi


echo "{"
echo -e "\t\"Ip\": \"$ip\","
echo -e "\t\"Port\": 3000,"
echo -e "\t\"Mask\": \"$mask\","
echo -e "\t\"Gateway\": \"$gway\","
echo -e "\t\"Dns1\": \"$dns1\","
echo -e "\t\"Dns2\": \"$dns2\","
echo -e "\t\"Dhcp\": $dhcp"
echo "}"



