#!/bin/bash
# set -e

current=$(readlink -f /etc/localtime)

echo "{"


echo -e "\t\"current\": \"$current\"," | sed -e "s/\/usr\/share\/zoneinfo\///g"
echo -e "\t\"options\": ["

file_list=()
while IFS= read -d $'\0' -r file ; do
    file_list=("${file_list[@]}" "$file")
done < <(find /usr/share/zoneinfo -print0 -type f | sort)

for file in "${file_list[@]}" ; do
    echo -e "\t\"$file\"," | sed -e "s/\/usr\/share\/zoneinfo\///g"
done

echo "\"\"]}"

exit 0





