#!/bin/bash

# script checks MAINS_FAIL pin and closes system
# script hould be started by start.sh script
# script hould be killed by stop.sh and reboot.sh scripts

DATETIME_NOW="`date '+%Y-%m-%d__%H-%M-%S'`"

_LOG="/home/root/lx4/log/scripts.log"
ROOT="/home/root"
LX4ROOT="$ROOT/lx4"
VERSION="2025.03.25"


echo "`date` lx4.sh:[$PPID->$$] starts VERSION = $VERSION" >> "$_LOG"
echo "`date` lx4.sh:[$PPID->$$] starts"

#enable supercaps
echo "8" > /sys/class/gpio/export
echo "out" > /sys/class/gpio/gpio8/direction
echo "1" > /sys/class/gpio/gpio8/value
sc=$(cat /sys/class/gpio/gpio8/value)
echo "`date` lx4.sh: supercaps enabled state $sc" >> "$_LOG"

#check POWER
echo "129" > /sys/class/gpio/export
echo "in" > /sys/class/gpio/gpio129/direction
power=$(cat /sys/class/gpio/gpio129/value)
if [ $power != "0" ]; then
	sleep 1.5s
	power=$(cat /sys/class/gpio/gpio129/value)
	if [ $power != "0" ]; then
		echo "`date` lx4.sh: power is down --> REBOOT"  >> "$_LOG"
		sh /home/root/lx4/scripts/reboot.sh
		exit 2
	fi
fi

# clear requests
if [[ -f $LX4ROOT/lx4.REBOOT_REQ ]]; then
	rm -f $LX4ROOT/lx4.REBOOT_REQ
fi
if [[ -f $LX4ROOT/lx4.STOP_REQ ]]; then
	rm -f $LX4ROOT/lx4.STOP_REQ
fi

# patch the OS
if [[ ! -f /usr/share/zoneinfo/Europe/Athens ]]; then
	echo "`date` lx4.sh: patch tzdata" >> "$_LOG"
	if [[ -f /home/root/lx4/scripts/patch/tzdata_patch.zip ]]; then 
		unzip -o /home/root/lx4/scripts/patch/tzdata_patch.zip -d /usr/share/zoneinfo/
		echo "`date` lx4.sh: tzdata applied" >> "$_LOG"
	fi
fi
if [[ ! -f /usr/share/fonts/truetype/DroidSansFallbackFull.ttf ]]; then
	echo "`date` lx4.sh: patch fonts" >> "$_LOG"
	if [[ -f /home/root/lx4/scripts/patch/DroidSansFallbackFull.ttf ]]; then
		cp -f /home/root/lx4/scripts/patch/DroidSansFallbackFull.ttf /usr/share/fonts/truetype/DroidSansFallbackFull.ttf
	echo "`date` lx4.sh: fonts updated" >> "$_LOG"
	fi
fi
if [[ -f /home/root/lx4/scripts/patch/sendsigs ]]; then
	cp -f /home/root/lx4/scripts/patch/sendsigs /etc/init.d/sendsigs
fi 

# Apply security items
chmod -x /usr/sbin/rpcbind
chmod -x /usr/sbin/rpc.statd
chmod -x /usr/sbin/tcf-agent

# Set OS version if not present
if [ ! -f /home/root/version ]; then
    echo -n 1.00 > /home/root/version
fi

# upgrade PB firmware
if [[ -f /home/root/lx4/bin/pbupgrade ]]; then
	chmod -R 766 /home/root/lx4/bin/pbupgrade
	echo "`date` lx4.sh: PB upgrade	-->	/home/root/lx4/bin/pbupgrade" >> "$_LOG"
	/home/root/lx4/bin/pbupgrade /home/root/pbupgradedone.inf
	echo "`date` lx4.sh: PB upgrade done	-->	/home/root/lx4/bin/pbupgrade" >> "$_LOG"
fi

cd "$LX4ROOT"

chmod 755 "$LX4ROOT"/bin/FileCoder

# export backup of database if requested
BACKUPFILE="$LX4ROOT/db/backup/databackup_${DATETIME_NOW}.zip"
BACKUPENCFILE="$LX4ROOT/db/backup/databackup_${DATETIME_NOW}.enc.zip"
if [[ -f /home/root/lx4/lx4.BACKUP_REQ ]]; then
	echo "" >> "$_LOG"
	echo "`date` lx4.sh: BACKUP IN PROGRESS	>>>>>>>" >> "$_LOG"

	rm -f ./lx4.BACKUP_REQ
	echo "`date` lx4.sh: file removed	-->	$LX4ROOT/lx4.BACKUP_REQ" >> "$_LOG"

	mkdir -p ./db/backup
	chmod 755 ./db/backup
	echo "`date` lx4.sh: folder created	-->	$LX4ROOT/db/backup" >> "$_LOG"

	python3 ./scripts/zip.py -r "$BACKUPFILE" ./db/data.db ./atg/swap.tmp
	echo "`date` lx4.sh: [db/data.db swap.tmp/*] zipped to	-->	$BACKUPFILE" >> "$_LOG"

	"$LX4ROOT"/bin/FileCoder -e "$BACKUPFILE" "$BACKUPENCFILE"

	sync
	rm -f "$BACKUPFILE"

	echo "`date` lx4.sh:  $BACKUPFILE encrypted to	-->	$BACKUPENCFILE, removing $BACKUPFILE" >> "$_LOG"

	chmod 644 $BACKUPENCFILE

	# copy it to usb root folder if connected
	USBROOT=/run/media/sda1
	if [[ -d $USBROOT ]]; then 
         cp -f $BACKUPENCFILE $USBROOT
         if [ $? -eq 0 ]; then
            echo "`date` lx4.sh: $BACKUPENCFILE copied to -->	$USBROOT" >> "$_LOG"
         else
            echo "`date` lx4.sh: ERROR. Copy $BACKUPENCFILE to -->	$USBROOT  FAILED" >> "$_LOG"
         fi  
   else
		echo "`date` lx4.sh: Copy backup skipped. USB not found" >> "$_LOG"
	fi
   echo "`date` lx4.sh: BACKUP FINISHED	<<<<<<<" >> "$_LOG"
   echo "" >> "$_LOG"
fi

# RESTORE FUNCTION
RESTOREFILE="$LX4ROOT/db/restore/restore.db.zip"
RESTOREENCFILE="$LX4ROOT/db/restore/restore.db.enc.zip"
RESTOREFILEDB="$LX4ROOT/db/restore/db_restore.db.zip"
RESTOREFILETEMP="$LX4ROOT/db/restore/temp_restore.db.zip"
RESTOREFILELINK="$LX4ROOT/db/restore/link_restore.db.zip"

if [[ -f /home/root/lx4/lx4.RESTORE_REQ ]]; then
	echo "" >> "$_LOG"
	echo "`date` lx4.sh: RESTORE IN PROGRESS	>>>>>>>" >> "$_LOG"

	rm -f /home/root/lx4/lx4.RESTORE_REQ
	echo "`date` lx4.sh: request removed	-->	/home/root/lx4/lx4.RESTORE_REQ" >> "$_LOG"

	if [[ -f $RESTOREFILE ]]; then
	      rm -f ./atg/swap.tmp/*
	      mv -f ./db/data.db ./db/data.bak
	      echo "`date` lx4.sh: old files removed" >> "$_LOG"
	      rm -f $RESTOREFILEDB
	      rm -f $RESTOREFILETEMP
	      rm -f $RESTOREFILELINK
	      echo "`date` lx4.sh: restore from backup" >> "$_LOG"
	      chmod 644 $RESTOREFILE
	      #rename restore file and try to decrypt (if it is not encrypted rename it once again)
	      echo "`date` lx4.sh: rename $RESTOREFILE   ---->  $RESTOREENCFILE" >> "$_LOG"
	      mv -f $RESTOREFILE $RESTOREENCFILE
	      "$LX4ROOT"/bin/FileCoder -d $RESTOREENCFILE $RESTOREFILE
	      EXIT_CODE=$?
	      if [ $EXIT_CODE -ne 0 ]; then
                    echo "`date` lx4.sh: restore from backup $EXIT_CODE" >> "$_LOG"
                    echo "`date` lx4.sh: rename $RESTOREENCFILE   ---->  $RESTOREFILE" >> "$_LOG"
                    mv -f $RESTOREENCFILE $RESTOREFILE
	      else
                    echo "`date` lx4.sh: decrypt $RESTOREENCFILE  ---->  $RESTOREFILE" >> "$_LOG"
	      fi

	      rm -f $RESTOREENCFILE
	      echo "`date` lx4.sh: remove $RESTOREENCFILE" >> "$_LOG"

	      unzip -o -q $RESTOREFILE "db/*" -d "$LX4ROOT"
	      EXIT_CODE=$?
	      if [ $EXIT_CODE -ne 0 ]; then
                    echo "`date` lx4.sh: unzipping $RESTOREFILE failed: $EXIT_CODE" >> "$_LOG"
	      fi
	      unzip -o -q $RESTOREFILE "swap.tmp/*" -d "$LX4ROOT/atg/"
	fi

	if [[ -f $RESTOREFILELINK ]]; then
	      chmod 644 $RESTOREFILELINK
	      archiveName=$(head -n 1 "$RESTOREFILELINK")
	      if [[ -n "$archiveName" ]] && [[ -f "$archiveName" ]]; then
                    rm -f ./atg/swap.tmp/*
                    mv -f ./db/data.db ./db/data.bak
                    echo "`date` lx4.sh: old files removed." >> "$_LOG"
                    rm -f $RESTOREFILEDB
                    rm -f $RESTOREFILETEMP

                    if [[ "$archiveName" == *"databackup"* ]]; then
                          # databackup*.zip file format
                          echo "`date` lx4.sh: decrypt $archiveName  ---->  $RESTOREFILE" >> "$_LOG"
                          "$LX4ROOT"/bin/FileCoder -d $archiveName $RESTOREFILE
                          EXIT_CODE=$?
                          UNPFILE=$RESTOREFILE
                          if [ $EXIT_CODE -ne 0 ]; then
                                echo "`date` lx4.sh: restore from backup $EXIT_CODE" >> "$_LOG"
                                UNPFILE=$archiveName
                          fi

                          unzip -o -q $UNPFILE "db/*" -d "$LX4ROOT"
                          EXIT_CODE=$?
                          if [ $EXIT_CODE -ne 0 ]; then
                                echo "`date` lx4.sh: unzipping $UNPFILE failed: $EXIT_CODE" >> "$_LOG"
                          fi
                          unzip -o -q $UNPFILE "swap.tmp/*" -d "$LX4ROOT/atg/"
                          echo "`date` lx4.sh: removing  $RESTOREFILE" >> "$_LOG"
                          rm -f $RESTOREFILE
                    else
                          # data*.zip file format
                          echo "`date` lx4.sh: restore from linked in old format backup: $archiveName " >> "$_LOG"
                          unzip -o -q "$archiveName" -d "$LX4ROOT/db"
                          # find temp_data
                          tempDataArchiveName="${archiveName//data/temp_data}"
                          if [[ -n "$tempDataArchiveName" ]] && [[ -f "$tempDataArchiveName" ]]; then
                                echo "`date` lx4.sh: restore from temp backup: $tempDataArchiveName " >> "$_LOG"
                                unzip -o -q "$tempDataArchiveName" -d "$LX4ROOT/atg/swap.tmp"
                          else
                                echo "`date` lx4.sh: restore swap.tmp skipped, $tempDataArchiveName file not found" >> "$_LOG"
                          fi
                    fi
              else
                    echo "`date` lx4.sh: restore skipped, linked file: $archiveName not found" >> "$_LOG"
	      fi
	fi

	# old format
	if [[ -f $RESTOREFILEDB ]]; then
		rm -f ./atg/swap.tmp/*
		mv -f ./db/data.db ./db/data.bak
		echo "`date` lx4.sh: old files removed" >> "$_LOG"                    
		echo "`date` lx4.sh: restore file in old format: data" >> "$_LOG"
		chmod 644 $RESTOREFILEDB
		unzip -o -q $RESTOREFILEDB -d "$LX4ROOT/db"
		if [[ -f $RESTOREFILETEMP ]]; then
                    echo "`date` lx4.sh: restore file in old format: temp" >> "$_LOG"
                    chmod 644 $RESTOREFILETEMP
                    unzip -o -q $RESTOREFILETEMP -d "$LX4ROOT/atg/swap.tmp"
		fi
	fi

	echo "`date` lx4.sh: files unzipped" >> "$_LOG"
	rm -f $RESTOREFILE
	rm -f $RESTOREFILEDB
	rm -f $RESTOREFILETEMP
	rm -f $RESTOREFILELINK
	echo "`date` lx4.sh: files removed" >> "$_LOG"

	echo "`date` lx4.sh: RESTORE FINISHED	<<<<<<<" >> "$_LOG"
        echo "" >> "$_LOG"
fi

if [[ -f "$LX4ROOT/db/data.bak" ]]; then
	if [[ ! -f "$LX4ROOT/db/data.db" ]]; then
	      echo "`date` lx4.sh: WRONG RESTORE RESULT, retrieving .bak database !!!" >> "$_LOG"
	      mv -f $LX4ROOT/db/data.bak $LX4ROOT/db/data.db
	      rm -f $LX4ROOT/atg/swap.tmp/*
	fi
	rm -f $LX4ROOT/db/data.bak
fi

# factory reset requested
if [[ -f /home/root/lx4/lx4.FACTORY_RESET_REQ ]]; then
	if [[ -f /home/root/lx4/db/data_empty.db ]]; then

		rm -r /home/root/lx4/log/*

		echo "" >> "$_LOG"
		echo "`date` lx4.sh: FACTORY RESET IN PROGRESS	>>>>>>>" >> "$_LOG"

		echo "`date` lx4.sh: files removed	-->	/home/root/lx4/log/*" >> "$_LOG"

		rm -f /home/root/lx4/lx4.FACTORY_RESET_REQ
		echo "`date` lx4.sh: request removed	-->	/home/root/lx4/lx4.FACTORY_RESET_REQ" >> "$_LOG"

		rm -f /home/root/lx4/db/data.db
		echo "`date` lx4.sh: file removed	-->	/home/root/lx4/db/data.db" >> "$_LOG"

		rm -f /home/root/lx4/atg/swap.tmp/*
		echo "`date` lx4.sh: files removed	-->	/home/root/lx4/atg/swap.tmp/*" >> "$_LOG"

		cp -f /home/root/lx4/db/data_empty.db /home/root/lx4/db/data.db
		echo "`date` lx4.sh: file copied	/home/root/lx4/db/data_empty.db --> /home/root/lx4/db/data.db" >> "$_LOG"
	else
		echo "`date` lx4.sh: file MISSING 	/home/root/lx4/db/data_empty.db" >> "$_LOG"
	fi
	echo "`date` lx4.sh: FACTORY RESET FINISHED	<<<<<<<" >> "$_LOG"   
	echo "" >> "$_LOG"   
fi

# swap reset requested
if [[ -f /home/root/lx4/lx4.SWAP_RESET_REQ ]]; then
	echo "" >> "$_LOG"
	echo "`date` lx4.sh: SWAP RESET IN PROGRESS	>>>>>>>" >> "$_LOG"

	rm -f /home/root/lx4/lx4.SWAP_RESET_REQ
	echo "`date` lx4.sh: request removed	-->	/home/root/lx4/lx4.SWAP_RESET_REQ" >> "$_LOG"

        ls /home/root/lx4/atg/swap.tmp/* | grep -v sld.dat | xargs rm
        sync
	echo "`date` lx4.sh: files removed	-->	/home/root/lx4/atg/swap.tmp/* except sld.dat" >> "$_LOG"
   
	echo "`date` lx4.sh: SWAP RESET FINISHED	<<<<<<<" >> "$_LOG"   
   echo "" >> "$_LOG"
fi

function unpack_update () {
# check if we need to update
UPDATELINK="$ROOT/link_lx4_new.zip"
UPDATEFILE="$ROOT/lx4_new.zip"
if [[ -f $UPDATEFILE || -f $UPDATELINK ]]; then

	# rename script log file, new file will be copied (saved) in update.sh script
        mv "$_LOG" "${_LOG}_old"

	echo "" >> "$_LOG"
	echo "`date` lx4.sh: UPDATE IN PROGRESS	>>>>>>>" >> "$_LOG"

        if [[ -f $UPDATELINK ]]; then
           chmod 644 $UPDATELINK
           UPDATEFILE=$(head -n 1 "$UPDATELINK")
           echo "`date` lx4.sh: firmware link $UPDATEFILE detected" >> "$_LOG"
           rm -f $UPDATELINK
           echo "`date` lx4.sh: firmware link $UPDATEFILE deleted" >> "$_LOG"
        fi

	# clean previous new version folder (just in case)
	if [[ -d /home/root/lx4_new ]]; then
		rm -d -r -f /home/root/lx4_new
		echo "`date` lx4.sh: folder removed	-->	/home/root/lx4_new" >> "$_LOG"
		# sleep 1
	fi

	chmod -R 755 /home/root
	echo "`date` lx4.sh: set 755 permissions	-->	/home/root" >> "$_LOG"

	# AVOID filling the log file
	# exec &>> /dev/null
	unzip $UPDATEFILE -d /home/root/
	ret=$?
	if [ $ret != "0" ]; then
		echo "`date` lx4.sh: unzip failed: code $ret" >> "$_LOG"
		sync
		rm -f /home/root/BootInfo.txt # remove reboot reason unknown
		echo "`date` lx4.sh: UPDATE FAILED	<<<<<<<" >> "$_LOG"
		echo "" >> "$_LOG"
		/sbin/reboot	# MUST REBOOT TO ENABLE WATCHDOG
	fi
	echo "`date` lx4.sh: file unzipped	-->	/home/root/lx4_new.zip	-->	/home/root/lx4_new" >> "$_LOG"
	sync

	chmod -R 755 /home/root/lx4_new/scripts
	echo "`date` lx4.sh: set 755 permissions	-->	/home/root/lx4_new/scripts" >> "$_LOG"

	chmod -R 755 /home/root/lx4_new/bin
	echo "`date` lx4.sh: set 755 permissions	-->	/home/root/lx4_new/bin" >> "$_LOG"

	chmod -R 755 /home/root/lx4_new/atg
	echo "`date` lx4.sh: set 755 permissions	-->	/home/root/lx4_new/atg" >> "$_LOG"

	# FOR DEBUG PURPOSE ONLY
	# mv /home/root/lx4_new.zip /home/root/lx4_new_${DATETIME_NOW}.zip

	rm -f /home/root/lx4_new.zip
	echo "`date` lx4.sh: file removed	-->	/home/root/lx4_new.zip" >> "$_LOG"

	echo "`date` lx4.sh: execute file	-->	/home/root/lx4_new/scripts/update.sh" >> "$_LOG"
	bash /home/root/lx4_new/scripts/update.sh
	echo "`date` lx4.sh: execution completed	-->	/home/root/lx4_new/scripts/update.sh" >> "$_LOG"

	# Restore stdout and close file descriptor #6.
	exec &>> /dev/null

	rm -f /home/root/BootInfo.txt
	echo -n "2" >> /home/root/lx4/BootInfo.txt
	echo "`date` lx4.sh: BootInfo.txt (reason = 2) has been created." >> "$_LOG"

	sync
	echo "`date` lx4.sh: UPDATE FINISHED	<<<<<<<" >> "$_LOG"
	echo "" >> "$_LOG"
	#/sbin/reboot	# MUST REBOOT TO ENABLE WATCHDOG

        return 0
else
        return 1
fi
}

# check if we need to update and update firmware
unpack_update
ret=$?

if [ $ret == 0 ]; then
   echo "`date` lx4.sh:	Rebooting... " >> "$_LOG"
   sh /home/root/lx4/scripts/reboot.sh &
   echo "129" > /sys/class/gpio/unexport
   exit 1
fi

# FIRST INSTALLATION
if [[ -f /home/root/lx4/db/data.db ]]; then
	echo ""
	echo "`date` lx4.sh: NORMAL EXECUTION" >> "$_LOG"
else
	echo "" >> "$_LOG"
	echo "`date` lx4.sh: FIRST EXECUTION		>>>>>>>" >> "$_LOG"

	cp -f /home/root/lx4/db/data_empty.db /home/root/lx4/db/data.db
	echo "`date` lx4.sh: file copied	/home/root/lx4/db/data_empty.db --> /home/root/lx4/db/data.db" >> "$_LOG"

	echo "`date` lx4.sh: FIRST EXECUTION FINSHED	<<<<<<<" >> "$_LOG"
	echo "" >> "$_LOG"
fi

# start
echo "`date` lx4.sh: set default serial port parameters" >> "$_LOG"
stty -F /dev/ttymxc4 9600 -parenb cs8 -cstopb
stty -F /dev/ttymxc1 9600 -parenb cs8 -cstopb

chmod -R 755 /home/root/lx4/scripts
echo "`date` lx4.sh: set 755 permissions	-->	/home/root/lx4/scripts" >> "$_LOG"

export QMLSCENE_DEVICE=softwarecontext
export QT_QPA_PLATFORM=linuxfb
 
cd /home/root/lx4
echo "`date` lx4.sh: set current folder         -->	/home/root/lx4" >> "$_LOG"

chmod 755 /home/root/lx4/supervisord
echo "`date` lx4.sh: set 755 permissions	-->	supervisord" >> "$_LOG"
echo "`date` lx4.sh: executing file		-->	./supervisord -c supervisord.conf -d &" >> "$_LOG"

chmod 644 -R /home/root/.ssh

# Restore stdout and close file descriptor #6.
exec &>> /dev/null

M0_FILE="/home/root/lx4/atg/swap.tmp/m0.dat"
MODEL=$(python3 /home/root/lx4/scripts/m0-ver.py "$M0_FILE")

if [[ "$MODEL" == "5" ]]; then
    rm -f /home/root/lx4/atg/swap.tmp/f*.dat
    rm -f /home/root/lx4/atg/swap.tmp/m0.dat
    echo "`date` lxu.sh: incorrect swap.tmp files err:$MODEL -> files are DELETED" >> "$_LOG"
fi

sync

# start supervisor
./supervisord -c supervisord.conf -d &
echo "`date` lx4.sh: supervisord started" >> "$START_LOG"
sleep 4s


function sigterm() {
	echo "`date` lx4.sh: SIGTERM received --> stop application"  >> "$_LOG"
	sh "$LX4ROOT/scripts/stop.sh "
	exit 0
}

trap sigterm SIGTERM


while true
do
	sleep 1s
  
	# checking REBOOT REQUEST
	REQUESTFILE="/home/root/lx4/lx4.REBOOT_REQ"
	if [[ -f $REQUESTFILE ]]; then
		echo "`date` lx4.sh: Detected REBOOT request." >> "$_LOG"
		rm -f $REQUESTFILE
		sync
		sleep 0.5
		echo "`date` lx4.sh: reboot request --> REBOOT" >> "$_LOG"      
		sh /home/root/lx4/scripts/reboot.sh &
		break
	fi 

        # STOP_REQ is created by stop.sh script
        REQUESTFILE="/home/root/lx4/lx4.STOP_REQ"
	if [[ -f $REQUESTFILE ]]; then
		echo "`date` lx4.sh:    stop request	-->	 STOP REQUEST" >> "$_LOG"
		rm -f $REQUESTFILE
        	break
	fi

	REQUESTFILE="/home/root/lx4/lx4.UPDATE_REQ"
	if [[ -f $REQUESTFILE ]]; then
		echo "`date` lx4.sh:	update request -->	 UPDATE REQUEST" >> "$_LOG"
		rm -f $REQUESTFILE
                sync
                unpack_update
                ret=$?
                if [ $ret != 0 ]; then
			echo "`date` lx4.sh:	update request but ZIP file not found. Rebooting... " >> "$_LOG"
                else
			echo "`date` lx4.sh:	update request ZIP file found. Rebooting... " >> "$_LOG"
                fi
		sh /home/root/lx4/scripts/reboot.sh &
		break
	fi   
   
	#check POWER
	power=$(cat /sys/class/gpio/gpio129/value)
	if [ $power != "0" ]; then
		sleep 1.5s
		power=$(cat /sys/class/gpio/gpio129/value)
		if [ $power != "0" ]; then
			echo "`date` lx4.sh: power is down --> REBOOT"  >> "$_LOG"
			sh /home/root/lx4/scripts/reboot.sh
			break
		fi     
	fi  
done  

echo "129" > /sys/class/gpio/unexport

echo "`date` lx4.sh: ends"  >> "$_LOG"

exit 0



