#!/bin/bash
_LOG="/home/root/lx4/log/scripts.log"

echo "`date` reboot.sh called" >> "$_LOG"

npid=$( pgrep -f supervisord | xargs)

if [ -z "$npid" ]; then
	echo "`date` reboot.sh: supervisord process not found" >> "$_LOG"
else
	# system must be closed first
	kill $npid

	for i in {0..30..1}
	do
		if [ -n "$(ps -p $npid -o pid=)" ]; then
			sleep 1s
		else
			break
		fi
	done
fi

echo "`date` reboot.sh: supervisord closed" >> "$_LOG"

#disable supercaps
if [[ ! -d /sys/class/gpio/gpio8 ]]; then
	echo "8" > /sys/class/gpio/export
fi
echo "0" > /sys/class/gpio/gpio8/value
sc=$(cat /sys/class/gpio/gpio8/value)
echo "`date` stop.sh: supercaps disabled state $sc" >> "$_LOG"

echo "`date` reboot.sh: rebooting..." >> "$_LOG"
echo " " >> "$_LOG"

# the system may be rebooted
reboot

