#!/bin/bash
set -e

_LOG="/home/root/lx4/log/scripts.log"

echo "`date` set-net.sh >>>>>>>" >> "$_LOG"


paramnum=$#
if [ "$#" -ne 6 ]; then
    echo "Wrong number arameters ${paramnum}! Usage: set-net.sh DHCP DNS1 DNS2 IP MASK GWAY"
    echo "`date` Wrong number arameters ${paramnum}! Usage: set-net.sh DHCP DNS1 DNS2 IP MASK GWAY" >> "$_LOG"
    echo "`date` set-net.sh <<<<<<<" >> "$_LOG"
    exit -1
fi

dhcp=$1
dns1=$2
dns2=$3
if [ "$dhcp" == "False" ]; then
   ip=$4
   mask=$5
   gway=$6
   echo "`date` set-net.sh: ip=${ip} mask=${mask}  gway=${gway}" >> "$_LOG"
fi

echo "`date` set-net.sh: dhcp=${dhcp} dns1=${dns1}  dns2=${dns2}" >> "$_LOG"


# MANAGE previous net configuration info
# --------------------------------------------------------------------------------------------------------------
NET_CONFIG="/home/root/lx4/last-network-config.txt"
if [[ -f $NET_CONFIG ]]; then
   rm -f $NET_CONFIG
   echo "`date` ${NET_CONFIG} file has been deleted" >> "$_LOG"
fi


device=$(connmanctl services | grep "ethernet" | awk '{split($0,a," ");print a[3]}')
echo "`date` set-net.sh: device=${device}" >> "$_LOG"

if [ "$dhcp" == "False" ]; then
   connmanctl config $device --ipv4 manual $ip $mask $gway
   echo "`date` set-net.sh: DHCP disabled" >> "$_LOG"
else
   connmanctl config $device --ipv4 dhcp
   echo "`date` set-net.sh: DHCP enabled" >> "$_LOG"
fi
connmanctl config $device --nameservers $dns1 $dns2

/etc/init.d/networking restart
sleep 5s


ip=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($2,a," ");print a[1]}')
mask=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($4,a," ");print a[1]}')
gway=$(ip route show | grep "default" | awk -F " " '{print $3}')
device=$(connmanctl services | grep "ethernet" | awk '{split($0,a," ");print a[3]}')
dns1=$(connmanctl services $device | grep "Nameservers = " | awk -F " " '{print $4}' | tr -d ',')
dns2=$(connmanctl services $device | grep "Nameservers = " | awk -F " " '{print $5}' | tr -d ',')
dhcpmode=$(connmanctl services $device | grep "IPv4 = " | awk -F " |=" '{print $8}' | tr -d ',')
# manual OR dhcp
dhcp=false

if [ $dhcpmode == "dhcp" ]; then
   dhcp=true
fi

echo "dev=$device" >> "$NET_CONFIG"
echo "ip=$ip" >> "$NET_CONFIG"
echo "mask=$mask" >> "$NET_CONFIG"
echo "gway=$gway" >> "$NET_CONFIG"
echo "dns1=$dns1" >> "$NET_CONFIG"
echo "dns2=$dns2" >> "$NET_CONFIG"
echo "dhcp=true" >> "$NET_CONFIG"

echo "`date` network parameters: " >> "$_LOG"
echo "`date`     IP   $ip" >> "$_LOG"
echo "`date`     mask $mask" >> "$_LOG"
echo "`date`     gate $gway" >> "$_LOG"
echo "`date`     dns1 $dns1" >> "$_LOG"
echo "`date`     dns2 $dns2" >> "$_LOG"
echo "`date`     dhcp $dhcp" >> "$_LOG"
echo "`date`     $NET_CONFIG has been changed" >> "$_LOG"
# --------------------------------------------------------------------------------------------------------------

echo "`date` set-net.sh <<<<<<<" >> "$_LOG"

# reboot the system
#sh /home/root/lx4/scripts/reboot.sh

