#!/bin/bash
set -e

DHCP_LOG="/home/root/lx4/log/scripts.log"

echo "`date` set-network-dhcp.sh called" >> "$DHCP_LOG"

dns1=$1
dns2=$2

if [ "$#" -lt 2 ]; then
    echo "Not enough params! Usage: set-network.sh DNS1 DNS2"
    echo "`date` Not enough params! Usage: set-network.sh DNS1 DNS2" >> "$DHCP_LOG"
    exit -1
fi

echo "`date` DHCP has been set" >> "$DHCP_LOG"

# MANAGE previous net configuration info
# --------------------------------------------------------------------------------------------------------------
NET_CONFIG="/home/root/lx4/last-network-config.txt"
if [[ -f $NET_CONFIG ]]; then
	rm -f $NET_CONFIG
fi


device=$(connmanctl services | grep "ethernet" | awk '{split($0,a," ");print a[3]}')
connmanctl config $device --ipv4 dhcp
connmanctl config $device --nameservers $dns1 $dns2
/etc/init.d/networking restart
sleep 5s


ip=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($2,a," ");print a[1]}')
mask=$(ifconfig | sed -n '/^eth0/,/^$/p' | grep "inet addr" | awk -F ":" '{split($4,a," ");print a[1]}')
gway=$(ip route show | grep "default" | awk -F " " '{print $3}')

echo "dev=$device" >> "$NET_CONFIG"
echo "ip=$ip" >> "$NET_CONFIG"
echo "mask=$mask" >> "$NET_CONFIG"
echo "gway=$gway" >> "$NET_CONFIG"
echo "dns1=$dns1" >> "$NET_CONFIG"
echo "dns2=$dns2" >> "$NET_CONFIG"
echo "dhcp=true" >> "$NET_CONFIG"

echo "`date` network parameters: " >> "$DHCP_LOG"
echo "`date`     IP   $ip" >> "$DHCP_LOG"
echo "`date`     mask $mask" >> "$DHCP_LOG"
echo "`date`     gate $gway" >> "$DHCP_LOG"
echo "`date`     dns1 $dns1" >> "$DHCP_LOG"
echo "`date`     dns2 $dns2" >> "$DHCP_LOG"
echo "`date`     dhcp true" >> "$DHCP_LOG"
echo "`date`     $NET_CONFIG has been changed" >> "$DHCP_LOG"
# --------------------------------------------------------------------------------------------------------------


# reboot the system
#sh /home/root/lx4/scripts/reboot.sh

