#!/bin/bash
set -e

NET_LOG="/home/root/lx4/log/scripts.log"

echo "`date` set-network.sh called" >> "$NET_LOG"

ip=$1
mask=$2
gway=$3
dns1=$4
dns2=$5

if [ "$#" -lt 5 ]; then
    echo "Not enough params! Usage: set-network.sh IP MASK GATEWAY DNS1 DNS2"
    echo "`date` Not enough params! Usage: set-network.sh IP MASK GATEWAY DNS1 DNS2" >> "$NET_LOG"
    exit -1
fi

echo "`date` network parameters: " >> "$NET_LOG"
echo "`date`     IP   $ip" >> "$NET_LOG"
echo "`date`     mask $mask" >> "$NET_LOG"
echo "`date`     gate $gway" >> "$NET_LOG"
echo "`date`     dns1 $dns1" >> "$NET_LOG"
echo "`date`     dns2 $dns2" >> "$NET_LOG"


# MANAGE previous net configuration info
# ----------------------------------------------------------
NET_CONFIG="/home/root/lx4/last-network-config.txt"
if [[ -f $NET_CONFIG ]]; then
	rm -f $NET_CONFIG
fi

echo "dev=$device" >> "$NET_CONFIG"
echo "ip=$ip" >> "$NET_CONFIG"
echo "mask=$mask" >> "$NET_CONFIG"
echo "gway=$gway" >> "$NET_CONFIG"
echo "dns1=$dns1" >> "$NET_CONFIG"
echo "dns2=$dns2" >> "$NET_CONFIG"
echo "dhcp=false" >> "$NET_CONFIG"

echo "`date`     $NET_CONFIG has been changed" >> "$NET_LOG"
# ----------------------------------------------------------


device=$(connmanctl services | grep "ethernet" | awk '{split($0,a," ");print a[3]}')
connmanctl config $device --ipv4 manual $ip $mask $gway
connmanctl config $device --nameservers $dns1 $dns2
/etc/init.d/networking restart

sleep 5s

# system must be closed first
#sh /home/root/lx4/scripts/reboot.sh

