#!/bin/bash
set -e

TIMEZONE_LOG="/home/root/lx4/log/scripts.log"
echo "`date` set-timezone.sh called" >> "$TIMEZONE_LOG"

echo "`date` set-timezone.sh Param1: $1" >> "$TIMEZONE_LOG";
echo "`date` set-timezone.shParam2: $2" >> "$TIMEZONE_LOG";

newDate=$1
timezone=$2

if [ "$#" -lt 1 ]; then
    echo "Param error! Usage: set-timezone.sh DATE [TIMEZONE]"
    echo "`date` set-timezone.sh  Param error!" >> "$TIMEZONE_LOG"
    exit -1
fi

if [ "$#" -eq 1 ]; then
    timezone=""
fi


date --set="$newDate"
hwclock --systohc --localtime

if [ "$timezone" != "" ]; then
    rm -f /etc/localtime
    ln -sf /usr/share/zoneinfo/$timezone /etc/localtime

   # system must be closed first
   echo "`date` set-timezone.sh time zone changed, rebooting..."  >> "$TIMEZONE_LOG"

   sh /home/root/lx4/scripts/reboot.sh &

else
    echo "`date` set-timezone.sh  changing time zone skipped" >> "$TIMEZONE_LOG"
fi

