#!/bin/bash

_LOG="/home/root/lx4/log/scripts.log"

echo "" >> "$_LOG"
echo "`date` start.sh:	-->	***********************************************************" >> "$_LOG"
echo "`date` start.sh:	-->	VERSION = 2024.12.03 13:44" >> "$_LOG"
echo ""
echo "`date` start.sh: --- disk usage statistics ----" >> "$_LOG"
df -h  >> "$_LOG"
echo "`date` start.sh: -----------------------------" >> "$_LOG"
echo "" >> "$_LOG"

npid=$( pgrep -f lx4.sh | xargs)

if [[ ! -z "$npid" ]]; then
   echo "`date` start.sh: LX4 (lx4.sh) already running" >> "$_LOG"
   echo "LX4 (lx4.sh) already running"
   exit 1
fi

iptables -A INPUT -p icmp --icmp-type timestamp-request -j DROP
iptables -A OUTPUT -p icmp --icmp-type timestamp-reply -j DROP

fake=$(sh /home/root/lx4/scripts/lx4.sh &)

echo "`date` start.sh: lx4.sh started" >> "$_LOG"
echo "`date` start.sh: lx4.sh started"

exit 0

