#!/bin/bash

_LOG="/home/root/lx4/log/scripts.log"

echo "`date` stop.sh: --- disk usage statistic ----" >> "$_LOG"
df -h  >> "$_LOG"
echo "`date` stop.sh: -----------------------------" >> "$_LOG"
echo "" >> "$_LOG"

echo "`date` stop.sh:[$$] try to terminate LX4 processes" >> "$_LOG"

# stop lx4.sh
touch "/home/root/lx4/lx4.STOP_REQ"

npid=$(pgrep -f supervisord | xargs)
if [ -z "$npid" ]; then
  echo "`date` stop.sh: supervisord process not found" >> "$_LOG"
else
  kill $npid
  echo "Waiting for supervisord to close"
  for i in {0..30..1}
  do
    if [ -n "$(ps -p $npid -o pid=)" ]; then
      sleep 1s
    else
      break
    fi
  done
fi
echo "`date` reboot.sh: supervisord closed" >> "$_LOG"

#disable supercaps
echo "0" > /sys/class/gpio/gpio8/value
sc=$(cat /sys/class/gpio/gpio8/value)
echo "`date` stop.sh: supercaps disabled state $sc" >> "$_LOG"
echo "8" > /sys/class/gpio/unexport

echo "`date` stop.sh: finished" >> "$_LOG"
echo "stop.sh: finished"

#killall iTouch
# iTouch has been closed by supervisord. In that case, hardware WDT was disabled
#sudo echo 'V' > /dev/watchdog

