#!/bin/bash

# enable error check/halt execution
# set -e

LOG_FILE="scripts.log"
_LOG="/home/root/lx4/log/$LOG_FILE"

echo "`date` update.sh: VERSION = 2024.09.30 	>>>>>>>" >> "$_LOG"

# unload all process
killall supervisord
#killall iTouch
echo "`date` update.sh: KILLED supervisord" >> "$_LOG"
sudo echo 'V' > /dev/watchdog
echo "`date` update.sh: WDT disabled" >> "$_LOG"
sleep 3


# save current db
# VERY IMPORTANT OPERATION
# ---------------------------------------------------------------------------------------------------------------------
cp -f /home/root/lx4/db/data.db /home/root/lx4_new/db
if [ $? -ne 0 ]; then
	echo "`date` update.sh: copy file FAILED	-->	/home/root/lx4/db/data.db --> /home/root/lx4_new/db" >> "$_LOG"
        echo "`date` update.sh: UPDATE FAILED 	<<<<<<<" >> "$_LOG"
	exit 1
fi
echo "`date` update.sh: file copied	-->	/home/root/lx4/db/data.db --> /home/root/lx4_new/db" >> "$_LOG"

# create folders if missing
mkdir -p /home/root/lx4/atg/swap.tmp
echo "`date` update.sh: create folder if missing	-->	/home/root/lx4/atg/swap.tmp" >> "$_LOG"
mkdir -p /home/root/lx4_new/atg/swap.tmp
echo "`date` update.sh: create folder if missing	-->	/home/root/lx4_new/atg/swap.tmp" >> "$_LOG"

chmod 755 /home/root/lx4/atg/swap.tmp
echo "`date` update.sh: set 755 permissions	-->	/home/root/lx4/atg/swap.tmp" >> "$_LOG"
chmod 755 /home/root/lx4_new/atg/swap.tmp
echo "`date` update.sh: set 755 permissions	-->	/home/root/lx4_new/atg/swap.tmp" >> "$_LOG"


cp -f /home/root/lx4/atg/swap.tmp/* /home/root/lx4_new/atg/swap.tmp
if [ $? -ne 0 ]; then
	echo "`date` update.sh: copy files FAILED	-->	/home/root/lx4/atg/swap.tmp/* --> /home/root/lx4_new/atg/swap.tmp" >> "$_LOG"
	exit 1
fi
echo "`date` update.sh: files copied	-->	/home/root/lx4/atg/swap.tmp/* --> /home/root/lx4_new/atg/swap.tmp" >> "$_LOG"

cp -f /home/root/lx4/atg/DebugLevel.txt /home/root/lx4_new/atg
if [ $? -ne 0 ]; then
	echo "`date` update.sh: cannot copy file	-->	/home/root/lx4/atg/DebugLevel.txt --> /home/root/lx4_new/atg" >> "$_LOG"
else
	echo "`date` update.sh: file copied	-->	/home/root/lx4/atg/DebugLevel.txt --> /home/root/lx4_new/atg" >> "$_LOG"
fi

sync


# create folders if missing
mkdir -p /home/root/lx4/db/backup
echo "`date` update.sh: created folder if missing	-->	/home/root/lx4/db/backup" >> "$_LOG"
mkdir -p /home/root/lx4/db/restore
echo "`date` update.sh: created folder if missing	-->	/home/root/lx4/db/restore" >> "$_LOG"
mkdir -p /home/root/lx4_new/db/backup
echo "`date` update.sh: created folder if missing	-->	/home/root/lx4_new/db/backup" >> "$_LOG"
mkdir -p /home/root/lx4_new/db/restore
echo "`date` update.sh: created folder if missing	-->	/home/root/lx4_new/db/restore" >> "$_LOG"


# apply permissions
chmod 755 /home/root/lx4/db/backup
echo "`date` update.sh: set 755 permissions	-->	/home/root/lx4/db/backup" >> "$_LOG"
chmod 755 /home/root/lx4/db/restore
echo "`date` update.sh: set 755 permissions	-->	/home/root/lx4/db/restore" >> "$_LOG"
chmod 755 /home/root/lx4_new/db/backup
echo "`date` update.sh: set 755 permissions	-->	/home/root/lx4_new/db/backup" >> "$_LOG"
chmod 755 /home/root/lx4_new/db/restore
echo "`date` update.sh: set 755 permissions	-->	/home/root/lx4_new/db/restore" >> "$_LOG"

# Apply security items
chmod -x /usr/sbin/rpcbind
chmod -x /usr/sbin/rpc.statd
chmod -x /usr/sbin/tcf-agent

# save current backups
cp -f /home/root/lx4/db/backup/* /home/root/lx4_new/db/backup
echo "`date` update.sh: files copied	-->	/home/root/lx4/db/backup/* --> /home/root/lx4_new/db/backup" >> "$_LOG"
# -----------------------------------------------------------------------------------------------------------------------------------


# invert
echo "`date` update.sh: SWAPPING AND REBOOTING..." >> "$_LOG"
cd /


# remove prev version
if [ -d "/home/root/lx4_old" ]; then
	# folder exist  	
	rm -d -r /home/root/lx4_old
	echo "`date` update.sh: folder removed	-->	/home/root/lx4_old" >> "$_LOG"
fi

#copy scripts log file
cp $_LOG  /home/root/lx4_new/log/$LOG_FILE

# keep current version
mv -f /home/root/lx4 /home/root/lx4_old
echo "`date` update.sh: folder moved	-->	/home/root/lx4 --> /home/root/lx4_old" >> "$_LOG"


# deploy new version
mv -f /home/root/lx4_new /home/root/lx4
sync
echo "`date` update.sh: folder moved	-->	/home/root/lx4_new --> /home/root/lx4" >> "$_LOG"

# remove .NET temporary files
rm -r /home/root/.net/
echo "`date` update.sh: removed files	-->	/home/root/.net" >> "$_LOG"

echo "`date` update.sh: UPDATE FINISHED 	<<<<<<<" >> "$_LOG"
