# RC, zip utility, compatible with basic zip options 

import zipfile
import os
import sys
from zipfile import ZipFile, ZIP_STORED, ZIP_DEFLATED

isVerbose = False

def addToZip(archive, path, isRecursive=False, compression=ZIP_DEFLATED, junkPaths=False):
    if os.path.isdir(path) and isRecursive:
        for root, dirs, files in os.walk(path):
            for file in files:
                if isVerbose:
                    print("Zip compressing:", file)
                filePath = os.path.join(root, file)
                arcname = os.path.basename(filePath) if junkPaths else os.path.relpath(filePath, os.path.join(path, '..'))
                archive.write(filePath, arcname=arcname, compress_type=compression)
    elif os.path.isfile(path):
        if isVerbose:
            print("Zip compressing:", path)
        arcname = os.path.basename(path) if junkPaths else path
        archive.write(path, arcname=arcname, compress_type=compression)

# --------- main
files = []
zipFilename = ""

compressionLevel = ZIP_DEFLATED
isRecursive = False
isJunkPaths = False

args = iter(sys.argv[1:])
for arg in args:
    if arg == '-r':
        isRecursive = True
    elif arg == '-j':
        isJunkPaths = True
    elif arg == '-v':
        isVerbose = True
    elif arg == '-0':
        compressionLevel = ZIP_STORED
    elif arg[0] == '-':
        continue
    else:
        zipFilename = arg
        files.extend(list(args))  # remaining args are files/dirs
        break

with ZipFile(zipFilename, 'w', compression=compressionLevel) as archive:
    for item in files:
        addToZip(archive, item, isRecursive, compressionLevel, isJunkPaths)

if isVerbose:
    print("Zip compression finished")
